type
  u8  = Byte;
  s8  = Shortint;
  u16 = Word;
  u32 = Longword;
  s16 = Smallint;
  s32 = Longint;
  f32 = Single;

  TTimeS  = s32;
  TTimeMS = u32;

  Pu8  = ^u8 ;
  Ps8  = ^s8 ;
  Pu16 = ^u16;
  Pu32 = ^u32;
  Ps16 = ^s16;
  Ps32 = ^s32;
  Pf32 = ^f32;

  PWordBool = ^WordBool;

  PTimeS  = ^TTimeS ;
  PTimeMS = ^TTimeMS;

  TCRC32 = u32;
  PCRC32 = ^TCRC32;

const
  bp8_cf_ChanelFrequencyCoefficient = 0.1;
  bp8_StrLen = 255;

type
  Tbp8_Str = array[0..bp8_StrLen] of AnsiChar;
  Pbp8_Str = ^Tbp8_Str;

type
  TMonitorHandle = THandle;
  PMonitorHandle = ^TMonitorHandle;

const
  INVALID_HANDLE_VALUE = THandle(0);

const
  bp8_st_Success                   = u32($00000000);

  bp8_st_InvalidParameters         = u32($00000001);
  bp8_st_LibCoreNotInitialized     = u32($00000002);
  bp8_st_LibCoreAlradyInitialized  = u32($00000003);
  bp8_st_ExtLibNotInitialized      = u32($00000004);
  bp8_st_ExtLibAlreadyInitialized  = u32($00000005);
  bp8_st_MemoryAccessError         = u32($00000006);
  bp8_st_OperationFailed           = u32($00000007);
  bp8_st_CRCError                  = u32($00000008);
  bp8_st_FileNotExist              = u32($00000009);
  bp8_st_FileAccessError           = u32($0000000A);
  bp8_st_FileDeleteError           = u32($0000000B);
  bp8_st_DataAccessError           = u32($0000000C);
  bp8_st_IndexOutOfBounds          = u32($0000000D);
  bp8_st_ProcessIsBusy             = u32($0000000E);
  bp8_st_UserBreak                 = u32($0000000F);
  bp8_st_ChannelNotUsed            = u32($00000010);
  bp8_st_MonitorNotOpened          = u32($00000011);
  bp8_st_PathIsOccupied            = u32($00000012);
  bp8_st_InvalidPathName           = u32($00000013);
  bp8_st_LogError                  = u32($00000014);
  bp8_st_LogIsEmpty                = u32($00000015);
  bp8_st_MonitorNotFound           = u32($00000016);
  bp8_st_DataNotExist              = u32($00000017);
  bp8_st_InvalidDataType           = u32($00000018);
  bp8_st_WrongData                 = u32($00000019);
  bp8_st_OperationIsNotSupported   = u32($0000001A);
  bp8_st_MonitorAlreadyInitialized = u32($0000001B);
  bp8_st_MissingMonitorProcess     = u32($0000001C);
  bp8_st_TimeSequenceError         = u32($0000001D);

  bp8_st_NotInitialized            = u32($00000100);
  bp8_st_DataStructError           = u32($00000101);
  bp8_st_FileNameError             = u32($00000102);

  bp8_st_MonDataDamaged            = u32($00000111);
  bp8_st_MonDataMissed             = u32($00000112);
  bp8_st_MonSectionContentError    = u32($00000113);

  bp8_st_MonInterfaceIncorrect     = u32($00000200);
  bp8_st_InterfaceIsBusy           = u32($00000201);
  bp8_st_CommunicationError        = u32($00000202);
  bp8_st_CommunicationAlreadyOpened= u32($00000203);
  bp8_st_MissingData               = u32($00000204);
  bp8_st_WrongMessage              = u32($00000205);
  bp8_st_MessageDeclined           = u32($00000206);
  bp8_st_MessageBroken             = u32($00000207);
  bp8_st_TimeOutError              = u32($00000208);
  bp8_st_UnknownMessage            = u32($00000209);
  bp8_st_OutOfMemory               = u32($0000020A);
  bp8_st_CommandIsNotSupported     = u32($0000020B);
  bp8_st_IncorrectCommandDataLength= u32($0000020C);



  bp8_st_FTDriverNotLoaded         = u32($00000220);
  bp8_st_FTPortNotExist            = u32($00000221);

  bp8_st_BTDriverNotLoaded         = u32($00000230);
  bp8_st_BTNotRadios               = u32($00000231);
  bp8_st_BTDiscoveryProcess        = u32($00000232);
  bp8_st_BTLibError                = u32($00000233);

  bp8_st_HIDLibLoadError           = u32($00000240);
  bp8_st_HIDNoDevices              = u32($00000241);

  bp8_st_ADCIndexError             = u32($00000301);
  bp8_st_SensorIDError             = u32($00000302);
  bp8_st_SensorIsNotAvailable      = u32($00000303);
  bp8_st_GroupIndexError           = u32($00000304);
  bp8_st_InvalidSampleSize         = u32($00000305);

  //Commands complete codes (results) = $0001XXXX
  //***************************************************
  //bp8_st_cmSuccess                 = u32($00010000);  //bp8_st_Success command result success
  bp8_st_cmUnknownError              = u32($00010001);  //unknown error
  bp8_st_cmMapNotAvailable           = u32($00010002);  //MAP is not available
  bp8_st_cmRegistratorIsNotStarted   = u32($00010003);  //Device is stopped. Files operation available only.
  bp8_st_cmModeIsStarted             = u32($00010004);  //the mode is started
  bp8_st_cmModeIsDisplayed           = u32($00010005);  //the mode is result displayed
  bp8_st_cmModeIsStopping            = u32($00010006);  //the mode is stopping
  bp8_st_cmModeIsStoped              = u32($00010007);  //the modes is stopped
  bp8_st_cmModeIsIncorrect           = u32($00010008);  //the modes is incorrect or the command is incorrect for this mode
  bp8_st_cmIncorrectChannelId        = u32($00010009);  //incorrect channel id
  bp8_st_cmNoPressureChannel         = u32($0001000A);  //pressure channel is not available
  bp8_st_cmRegistrationDataIsStarted = u32($0001000B);  //registration data is started
  bp8_st_cmDataIsTransmitting        = u32($0001000C);  //the data is transmitting
  bp8_st_cmFileCRCError              = u32($0001000D);  //the file CRC error
  bp8_st_cmFileSNError               = u32($0001000E);  //the serial number of file configuration is not coincides with serial number of device
  bp8_st_cmIncorrectParameter        = u32($0001000F);  //Invalid option for the team
  bp8_st_cmModeIsStarting            = u32($00010010);  //the mode is starting
  bp8_st_cmMapNotInit                = u32($00010011);  //MAP is not init

  bp8_st_UnknownError                = u32($0000FFFF);
  bp8_st_Unknown                     = u32($FFFFFFFF);


  BP2008SDK_ostSuccess           = $00000000;
  BP2008SDK_ostNotInitialized    = $00000100;
  BP2008SDK_ostDataStructError   = $00000101;
  BP2008SDK_ostFileNameError     = $00000102;
  BP2008SDK_ostUnknown           = $FFFFFFFF;
  //***************************************************

const
  //Default names and values used in metadata file
  mdc_SectionName    = 'BPLAB';
  mdc_ExamID         = 'ExamID';
  mdc_PatName        = 'PatName';
  mdc_PatAge         = 'Age';
  mdc_ManualFieldStr: AnsiString = 'Manual';
  mdc_SetupDataCRC32: AnsiString = 'SetupDataCRC32';

const
  bp8_c_Augment_Error       = $00FF;
  bp8_c_Augment_Disabled    = $0000; // pump is not started //  
  bp8_c_Augment_InProgress  = $0001; // pumping process     //   
  bp8_c_Augment_Hold        = $0002; // hold pressure       //    

const
  //State codes of emergency lock
  bp8_c_sclOk              = $EE;
  bp8_c_sclTime120         = $80;  //Time exceeded 2 min
  bp8_c_sclPres295         = $81;  //Pressure exceeded 295/210 mmHg (for more than 15 seconds)
  bp8_c_sclPres320         = $82;  //Pressure exceeded 320/220 mmHg
  bp8_c_sclPres15          = $84;  //during the measurement, pressure did not exceed 15 mm in 70 seconds
  bp8_c_sclNo30sec         = $85;  //Pressure in a pneumatic system has again raised before the termination of a protective 30-sec. pause
  bp8_c_sclMainMaxOffset   = $86;  //Could not adjust the offset in the main channel offset above the permissible
  bp8_c_sclMainMinOffset   = $87;  //Could not adjust the offset in the main channel offset below the allowable
  bp8_c_sclGuardMaxOffset  = $88;  //Could not adjust the offset in the guard channel offset above the permissible
  bp8_c_sclGuardMinOffset  = $89;  //Could not adjust the offset in the guard channel offset below the allowable


const
  //  
  bp8_c_SigChannel_Unknown     = $00;  //
  bp8_c_SigChannel_Power       = $01;  // Battery
  bp8_c_SigChannel_Press       = $02;  // Pressure
  bp8_c_SigChannel_Auscultic   = $03;  // Auscultic pressure
  bp8_c_SigChannel_Cardio_I    = $04;  // ECG Lead I
  bp8_c_SigChannel_Cardio_II   = $05;  // ECG Lead II
  bp8_c_SigChannel_Cardio_III  = $06;  // ECG Lead III
  bp8_c_SigChannel_Cardio_LR   = $07;  // ECG Lead LR
  bp8_c_SigChannel_Cardio_RF   = $08;  // ECG Lead RF
  bp8_c_SigChannel_Cardio_V1   = $09;  // ECG Lead V1
  bp8_c_SigChannel_Cardio_V2   = $0A;  // ECG Lead V2
  bp8_c_SigChannel_Cardio_V3   = $0B;  // ECG Lead V3
  bp8_c_SigChannel_Cardio_V4   = $0C;  // ECG Lead V4
  bp8_c_SigChannel_Cardio_V5   = $0D;  // ECG Lead V5
  bp8_c_SigChannel_Cardio_V6   = $0E;  // ECG Lead V6
  bp8_c_SigChannel_MAPx        = $0F;  // MAP x
  bp8_c_SigChannel_MAPy        = $10;  // MAP y
  bp8_c_SigChannel_Microphone  = $11;  // Microphone

  //for compatibility with old designations (CR#0008877)
  bp8_c_SigChannel_Cardio_LP   = bp8_c_SigChannel_Cardio_LR;
  bp8_c_SigChannel_Cardio_LN   = bp8_c_SigChannel_Cardio_RF;


type
  Tbp8_SigChannelType = bp8_c_SigChannel_Unknown..bp8_c_SigChannel_Microphone;
  Tbp8_SigChannelSet = set of Tbp8_SigChannelType;

const
  bp8_c_EventTypeID_Undefined        = $0000;
  bp8_c_EventTypeID_Pulse            = $0001; // Pulse wave detected
                                              //    

  bp8_c_EventTypeID_UserEvent        = $0002; // Button pressed during monitoring
                                              //     

  bp8_c_EventTypeID_GroupRecordStart = $0003; // Start registration channel group recording //     

  bp8_c_EventTypeID_PMD              = $0004; // Artificial pacemaker pulse detected
                                              //   

//bp8_c_EventTypeID_PMDUpReset       = $0005; // Not used //  
//bp8_c_EventTypeID_PMDDownSet       = $0006; // Not used //  
//bp8_c_EventTypeID_PMDDownReset     = $0007; // Not used //  

  bp8_c_EventTypeID_PeripheralsON    = $0008; // The power of pressure measurement module is turned on
                                              //    - 

  bp8_c_EventTypeID_PeripheralsOFF   = $0009; // The power of pressure measurement module is turned off
                                              //    - 

  bp8_c_EventTypeID_Error            = $000A; // Internal error
                                              //  

  bp8_c_EventTypeID_MonitorStart     = $000B; // The device is powered on
                                              //  

  bp8_c_EventTypeID_FTDIConnect      = $000C; // FTDI connected
                                              //    FTDI

  bp8_c_EventTypeID_FTDIDisconnect   = $000D; // FTDI disconnected
                                              //    FTDI

  bp8_c_EventTypeID_BTConnect        = $000E; // BT connected
                                              //    BT

  bp8_c_EventTypeID_BTDisconnect     = $000F; // BT disconnected
                                              //    BT

  bp8_c_EventTypeID_USBConnect       = $0010; // USB connected
  bp8_c_EventTypeID_USBDisconnect    = $0011; // USB disconnected

  bp8_c_EventTypeID_Max              = $0012; // ???

type
  Tbp8_EventTypeID = bp8_c_EventTypeID_Undefined..bp8_c_EventTypeID_Max;
  Tbp8_EventTypeIDSet = set of Tbp8_EventTypeID;

const
  //************************************
  //* Measurement type:
  //************************************
  bp8_c_MeasType_extraordinary = $0001; // Extraordinary // 
  bp8_c_MeasType_repeat        = $0002; // Repeat        // 
  bp8_c_MeasType_regular       = $0004; // Regular       // 


  //************************************
  //* Cause extraordinary measure
  //************************************
  bp8_c_MeasReason_Unconditional   = $0001; // Bit 0 : unconditional start
  bp8_c_MeasReason_Orthostatic     = $0002; // Bit 1 : under the terms of orthostatic
  bp8_c_MeasReason_Verification    = $0004; // Bit 2 : verification
  bp8_c_MeasReason_User            = $0008; // Bit 3 : start measuring user
  bp8_c_MeasReason_NotUsed         = $0010; // Bit 4 : (bp8_c_MeasReason_ExtVerification) external verification
  bp8_c_MeasReason_AfterReset      = $0020; // Bit 5 : measure after reset
  bp8_c_MeasReason_AdaptationReset = $0040; // Bit 6 : adaptation reset

const
  bp8_c_PeripheralsID_Pump = $0000;

type
  Tbp8_PeripheralsID = bp8_c_PeripheralsID_Pump..bp8_c_PeripheralsID_Pump;


type
  Pbp8_SigChannelInfo = ^Tbp8_SigChannelInfo;
  Tbp8_SigChannelInfo = packed record
    SignalSource: Tbp8_SigChannelType;  // Type of chanel sygnal
    Frequency: f32;                     // Sampling frequency
    MaxSampleValue: u16;                // Dynamic range of the sample
  end;

  Pbp8_ChannelMaxMin = ^Tbp8_ChannelMaxMin;
  Tbp8_ChannelMaxMin = packed record
    ValMAX: s32; // Maximum value of the sensors dynamic range
                 //   

    ValMIN: s32; // Minimum value of the sensors dynamic range
                 //   
  end;

const
  bp8_cs_PowerSigChannels: Tbp8_SigChannelSet =
    [bp8_c_SigChannel_Power
    ];

  bp8_cs_PressureSigChannels: Tbp8_SigChannelSet =
    [bp8_c_SigChannel_Press,
     bp8_c_SigChannel_Auscultic
    ];

  bp8_cs_ECGSigChannels: Tbp8_SigChannelSet =
    [bp8_c_SigChannel_Cardio_I
    ,bp8_c_SigChannel_Cardio_II
    ,bp8_c_SigChannel_Cardio_III
    ,bp8_c_SigChannel_Cardio_LR
    ,bp8_c_SigChannel_Cardio_RF
    ,bp8_c_SigChannel_Cardio_V1
    ,bp8_c_SigChannel_Cardio_V2
    ,bp8_c_SigChannel_Cardio_V3
    ,bp8_c_SigChannel_Cardio_V4
    ,bp8_c_SigChannel_Cardio_V5
    ,bp8_c_SigChannel_Cardio_V6
    ];

  bp8_cs_MAPSigChannels: Tbp8_SigChannelSet =
    [bp8_c_SigChannel_MAPx,
     bp8_c_SigChannel_MAPy
    ];

  bp8_cs_MicrophoneSigChannels: Tbp8_SigChannelSet =
    [bp8_c_SigChannel_Microphone
    ];

type
  Tbp8_CommandId = u8;

const
  bp8_cmi_GetDevConfiguration    : Tbp8_CommandId = $00;
  bp8_cmi_SetDevConfiguration    : Tbp8_CommandId = $01;
  bp8_cmi_GetActivityData        : Tbp8_CommandId = $02;
  bp8_cmi_DoBPMeasurement        : Tbp8_CommandId = $03;
  bp8_cmi_GetCurrentPressure     : Tbp8_CommandId = $04;
  bp8_cmi_StartStreaming         : Tbp8_CommandId = $05;
  bp8_cmi_StopStreaming          : Tbp8_CommandId = $06;
  bp8_cmi_RunManometer           : Tbp8_CommandId = $07;
  bp8_cmi_StopMode               : Tbp8_CommandId = $08;
  bp8_cmi_StopDevice             : Tbp8_CommandId = $09;
  bp8_cmi_SetDevOperationMode    : Tbp8_CommandId = $0A;
  bp8_cmi_GetDevOperationMode    : Tbp8_CommandId = $0B;
  bp8_cmi_SetMetadata            : Tbp8_CommandId = $0C;
  bp8_cmi_GetMetadata            : Tbp8_CommandId = $0D;
  bp8_cmi_GetActivity            : Tbp8_CommandId = $0E;
  bp8_cmi_FilesFlush             : Tbp8_CommandId = $0F;
  bp8_cmi_GetResultsTab          : Tbp8_CommandId = $10;
  bp8_cmi_GetEventTab            : Tbp8_CommandId = $11;
  bp8_cmi_GetStagesTab           : Tbp8_CommandId = $12;
  bp8_cmi_GetGroupSessionsCount  : Tbp8_CommandId = $13;
  bp8_cmi_GetChannelGroup        : Tbp8_CommandId = $14;
  bp8_cmi_InitActivitySensor     : Tbp8_CommandId = $15;
  bp8_cmi_GetDevStatus           : Tbp8_CommandId = $16;
  bp8_cmi_CleanupData            : Tbp8_CommandId = $17;
  bp8_cmi_CancelPlanMeas         : Tbp8_CommandId = $18;
  bp8_cmi_PumpToTargetPressure   : Tbp8_CommandId = $19;
  bp8_cmi_RunRegistrationData    : Tbp8_CommandId = $1A;
  bp8_cmi_GetSizeDevOperationMode: Tbp8_CommandId = $1B;
  bp8_cmi_GetSizeResultsTab      : Tbp8_CommandId = $1C;
  bp8_cmi_GetSizeEventTab        : Tbp8_CommandId = $1D;
  bp8_cmi_GetSizeStagesTab       : Tbp8_CommandId = $1E;
  bp8_cmi_GetSizeMetadata        : Tbp8_CommandId = $1F;
  bp8_cmi_GetSizeChannelGroup    : Tbp8_CommandId = $20;


type
  Pbp8_TransmitInfo = ^Tbp8_TransmitInfo;
  Tbp8_TransmitInfo = packed record
    Direct      : u8;      // Direction of data transmission (used constants bp8_cdd_*****)
    TimeS       : TTimeS;  // Time of transmission in second
    TimeMSBefore: TTimeMS; // The count of ms from Time before transmission process
    TimeMSAfter : TTimeMS; // The count of ms from Time after transmission process
    Count       : s32;     // Planned data lenght of transmission
    RealCount   : s32;     // Real data lenght of transmission
    Result      : u32;     // Result of transmission process
  end;

  Pbp8_TakenDataInfo = ^Tbp8_TakenDataInfo;
  Tbp8_TakenDataInfo = packed record
    CommandId: Tbp8_CommandId;
    TimeS    : TTimeS;
    Size     : u16;
  end;

const
  //Values of data transmission direction
  bp8_cdd_Receive = $00;
  bp8_cdd_Send    = $01;


const
  bp8_c_ExamIdLength = 8;
  bp8_c_PatNameLength = 16;

type
  Pbp8_BPMetadata = ^Tbp8_BPMetadata;
  Tbp8_BPMetadata = packed record
    Age: u8;
    ExamID : array[0..bp8_c_ExamIdLength] of u8;
    PatName : array[0..bp8_c_PatNameLength] of u8;
    //SetupDataCRC32: u32;
  end;


const
  //Tbp8_MonitorInterface
  bp8_mi_None      = $00;
  bp8_mi_Directory = $01;
  bp8_mi_FTDI      = $02;
  bp8_mi_BT        = $03;
  bp8_mi_COM       = $04;
  bp8_mi_HID       = $05;

type
  Tbp8_MonitorInterface = u8; // used constants bp8_mi_*****
  Tbp8_MonitorPortNumber = s32;

type
  Tbp8_MonitorInterfaceSet = set of Tbp8_MonitorInterface;

const
  bp8_mis_Comm: Tbp8_MonitorInterfaceSet = [bp8_mi_FTDI, bp8_mi_BT, bp8_mi_COM, bp8_mi_HID];
  bp8_mis_Path: Tbp8_MonitorInterfaceSet = [bp8_mi_Directory];


const
  bp8_mp_AutoFTDIPortNumber:Tbp8_MonitorPortNumber = -1;

type
  Pbp8_MonitorInterfaceInfo = ^Tbp8_MonitorInterfaceInfo;
  Tbp8_MonitorInterfaceInfo = packed record
    CommType  : Tbp8_MonitorInterface;
    PortNumber: Tbp8_MonitorPortNumber;
  end;

const
  bp8_bpmr_Unconditional          =$00;
  bp8_bpmr_UnconditionalWithReset =$02;

type
   Tbp8_BPMReason = bp8_bpmr_Unconditional..bp8_bpmr_UnconditionalWithReset;

{******************************************************************************}
{*    Monitor data structures                                                 *}
{******************************************************************************}

//************************************
//* DevConfig structures
//************************************

const
  //    (  Tbp8_DevConfig_Connectivity)
  bp8_c_PortID_Bluetooth = 0;
  bp8_c_PortID_FTDI      = 1;
  bp8_c_PortID_USBHID    = 2;

  //bp8_c_PortID_Min = bp8_c_PortID_Bluetooth;
  //bp8_c_PortID_Max = bp8_c_PortID_USBHID;
type
  Tbp8_PortId = bp8_c_PortID_Bluetooth..bp8_c_PortID_USBHID;

const
  //    (  Tbp8_DevConfig_SensorList)

  bp8_c_SensorID_Battery    =  00; //   
  bp8_c_SensorID_Press_W    =  01; //   
  bp8_c_SensorID_Press_0    =  02; //    
  bp8_c_SensorID_Press_1    =  03; //    
  bp8_c_SensorID_Auscultic  =  04; //  
  bp8_c_SensorID_Cardio_I   =  05; //  I 
  bp8_c_SensorID_Cardio_II  =  06; //  II 
  bp8_c_SensorID_Cardio_III =  07; //  III 
  bp8_c_SensorID_Cardio_LR  =  08; //  LR
  bp8_c_SensorID_Cardio_RF  =  09; //  RF
  bp8_c_SensorID_Cardio_V1  =  10; //  V1
  bp8_c_SensorID_Cardio_V2  =  11; //  V2
  bp8_c_SensorID_Cardio_V3  =  12; //  V3
  bp8_c_SensorID_Cardio_V4  =  13; //  V4
  bp8_c_SensorID_Cardio_V5  =  14; //  V5
  bp8_c_SensorID_Cardio_V6  =  15; //  V6
  bp8_c_SensorID_MAPx       =  16; //  x
  bp8_c_SensorID_MAPz       =  17; //  z
  bp8_c_SensorID_Microphone =  18; //   

  //for compatibility with old designations (CR#0008877)
  bp8_c_SensorID_Cardio_LP  =  bp8_c_SensorID_Cardio_LR;
  bp8_c_SensorID_Cardio_LN  =  bp8_c_SensorID_Cardio_RF;


type
  Tbp8_SensorID = bp8_c_SensorID_Battery..bp8_c_SensorID_Microphone;

const
  bp8_c_PlatformID_BP2008 = $0008;

type
  Tbp8_PlatformID = bp8_c_PlatformID_BP2008..bp8_c_PlatformID_BP2008;

const
  bp8_c_DeviceType_BPLab = $0001;
  bp8_c_DeviceType_Twin  = $0002;
  bp8_c_DeviceType_ECG   = $0003;

type
  Tbp8_DeviceType = bp8_c_DeviceType_BPLab..bp8_c_DeviceType_ECG;

const
  bp8_c_Locale_Ru = $0000;
  bp8_c_Locale_En = $0001;
  bp8_c_Locale_Fr = $0002;
  bp8_c_Locale_It = $0003;
  bp8_c_Locale_De = $0004;
  bp8_c_Locale_Fi = $0005;
  bp8_c_Locale_Pt = $0006;
  //bp8_c_Locale_Es = $000_;
type
  Tbp8_Locale = bp8_c_Locale_Ru..bp8_c_Locale_Pt; //bp8_c_Locale_Es;


const
  // Artificial pacemaker detector type
  bp8_c_PMDType_None   = $0000; // No detector
  bp8_c_PMDType_Analog = $0001; // Analog detector

type
  Tbp8_PMDType = bp8_c_PMDType_None..bp8_c_PMDType_Analog;

const
  bp8_c_SerialNumberLength = 16;
  bp8_c_VersionFWLength    = 18;
  bp8_c_VersionHWLength    = 18;
  bp8_c_VersionGuardLength = 18;

type
  Tbp8_SerialNumber = array[0..bp8_c_SerialNumberLength - 1] of u8;
  Tbp8_VersionFW    = array[0..bp8_c_VersionFWLength    - 1] of u8;
  Tbp8_VersionHW    = array[0..bp8_c_VersionHWLength    - 1] of u8;
  Tbp8_VersionGuard = array[0..bp8_c_VersionGuardLength - 1] of u8;

type
  // Device identity
  Tbp8_DevConfig_DeviceID = packed record
    PlatformID   : u16;               // Platform ID (see Tbp8_PlatformID)
    DeviceType   : u16;               // Device type (see Tbp8_DeviceType)
    SerialNumber : Tbp8_SerialNumber; // Device serial number
    VersionFW    : Tbp8_VersionFW;    // Firmware version
    VersionHW    : Tbp8_VersionHW;    // Hardware version
    VersionGuard : Tbp8_VersionGuard; // Guard firmware version
  end;

  // System Preferences
  Tbp8_DevConfig_System = packed record
    SelfInit  : u8;  // Enable system mode self-init
    Locale    : u8;  // Device languge (see Tbp8_Locale)
  end;

  // Signal source (sensor) descriptor
  Tbp8_DevConfig_Sensor = packed record
    ADCMask   : u8;  // ADC availability bit mask
    ChannelID : u8;  // ADC channel number on which the sensor signal is available
    ValMAX    : s32; // Maximum value of the sensors dynamic range
    ValMIN    : s32; // Minimum value of the sensors dynamic range
  end;

  // List of signal source (sensor) descriptors
  Tbp8_DevConfig_SensorList = array[Tbp8_SensorID] of Tbp8_DevConfig_Sensor;

  // Communication port descriptor
  Tbp8_DevConfig_Port  = packed record
    Available: u8; // Port availability
    Port: u8;      // UART port number
    BaudRate: u16; // Data transmission baudrate
  end;

  // List of communication port descriptors
  Tbp8_DevConfig_Connectivity = array[Tbp8_PortId] of Tbp8_DevConfig_Port;

  // Blood pressure measurement module parameters
  Tbp8_DevConfig_BPMeter = packed record
    Availability       : u8;  // Module availability
    Auscultation       : u8;  // Availability of auscultatory blood pressure measurement method
    ValveHoldPWMPeriod : u8;  // PWM period of valve retention
    ValveHoldPWMFactor : u8;  // PWM duty cycle of valve retention
    TAU                : u32; // Time coefficient of the pump/relief
    MainCorr           : s16; // Excluded and reserved in v.2.2.xx
    GuardCorr          : s16; // Correction factor for emergency pressure sensor
  end;

  // Calibration data of patient monitor activity registration module
  Pbp8_DevConfig_MAPCalibration = ^Tbp8_DevConfig_MAPCalibration;
  Tbp8_DevConfig_MAPCalibration = packed record
    GZeroShiftX : u16; // X axis zero offset
    GLengthX    : u16; // X axis range
    case boolean of
      true: //It's true using
       (GZeroShiftY : u16;  // Y axis zero offset
        GLengthY    : u16); // Y axis range
      false: // need for compatibility with API BP2008SDK_XXXXXXXXXXXX
       (GZeroShiftZ : u16;
        GLengthZ    : u16);
  end;

  // Parameters of internal patient monitor activity registration module
  Tbp8_DevConfig_AccelerometerInt = packed record
    Availability   : u8;                            // Module availability
    MAPCalibration : Tbp8_DevConfig_MAPCalibration; // Calibration data of patient monitor activity registration module
  end;

  // Parameters of external patient monitor activity registration module
  Tbp8_DevConfig_AccelerometerExt = packed record
    Availability: u8; // SDK
  end;

  // Parameters of patient monitor activity registration mo dule.
  // Consists of Accel erometerInt and AccelerometerExt sections.
  Tbp8_DevConfig_Accelerometer = packed record
    // Parameters of internal patient monitor activity registration module
    AccelerometerInt:Tbp8_DevConfig_AccelerometerInt;

    // Parameters of external patient monitor activity registration module
    // An external module in daily accelerometer monitors ECG/BP BP2008 02.01.xx version is not available
    AccelerometerExt:Tbp8_DevConfig_AccelerometerExt;
  end;

  // ECG module parameters
  Tbp8_DevConfig_ECG = packed record
    PMDType: u8; // Artificial pacemaker detector type (see bp8_c_PMDType_XXX constants)
  end;

  //Extended device configuration (not available in standart SDK)
  Pbp8_SignatureExt = ^Tbp8_SignatureExt;
  Tbp8_SignatureExt = packed record
    DeviceID         : Tbp8_DevConfig_DeviceID;      // Device identity
    System           : Tbp8_DevConfig_System;        // System Preferences
    SensorList       : Tbp8_DevConfig_SensorList;    // List of signal source (sensor) descriptors
    Connectivity     : Tbp8_DevConfig_Connectivity;  // List of communication port descriptors
    BPMeter          : Tbp8_DevConfig_BPMeter;       // Blood pressure measurement module parameters
    Accelerometer    : Tbp8_DevConfig_Accelerometer; // Parameters of patient monitor activity registration mo dule.
    ECG              : Tbp8_DevConfig_ECG;           // ECG module parameters
    CRC              : u32;
  end;

  TDeviceSerialNumber = Tbp8_SerialNumber;
  TSoftwareVersion = Tbp8_VersionFW;

  //Device configuration
  Pbp8_Signature = ^Tbp8_Signature;
  Tbp8_Signature = packed record
    PlatformID        : u16;                 // Platform ID (see Tbp8_PlatformID)
    SerialNumber      : TDeviceSerialNumber; // Device serial number
    Version           : TSoftwareVersion;    // Firmware version
    DeviceType        : u16;                 // Device type (see Tbp8_DeviceType)
    Auscultation      : u8;                  // Availability of auscultatory blood pressure measurement method
    BluetoothEnabled  : u8;                  // Availability of Bluetooth using
    InternalMAPEnabled: u8;                  // Availability of internal MAP using
    ExternaMAPEnabled : u8;                  // Availability of external MAP using
    SelfInitEnabled   : u8;                  // Enable system mode self-init
    ValveHoldPWMPeriod: u8;                  // PWM period
    ValveHoldPWMFactor: u8;                  // PWM off-duty factor
    //SysLOCALE         : Tbp8_Locale;         //  
  end;


{******************************************************************************}

  //************************************
  //* DevOperationMode structures
  //************************************

const
  // Types of digital signal processing (for Tbp8_DevOperationMode_Channel.FilterType)
  bp8_c_FilterType_NONE   = $00;
  bp8_c_FilterType_FIR64  = $01;
  bp8_c_FilterType_FIR40  = $02;
  bp8_c_FilterType_AMPENV = $03;
  bp8_c_FilterType_MAX    = $04;
  bp8_c_FilterType_FIR80  = $05;
  bp8_c_FilterType_EXAV   = $06;

type
  Tbp8_FilterType = bp8_c_FilterType_NONE..bp8_c_FilterType_EXAV;

const
  //Operation modes of the blood pressure measurement modfule (for Tbp8_DevOperationMode_BPMonitorInf.FuncMode)
  bp8_c_FuncMode_Technology    = $00; // Technology. Used in the adjustment and repair;
  bp8_c_FuncMode_Certification = $01; // Certification. Used in the certification and verification;
  bp8_c_FuncMode_Clinical      = $02; // Clinical. Native mode. Used in a clinical trial;

type
  Tbp8_FuncMode = bp8_c_FuncMode_Technology..bp8_c_FuncMode_Clinical;

const
  //Age ranges (for Tbp8_DevOperationMode_BPMonitorInf.AdultMode)
  bp8_c_AdultMode_Children = $00; // Children; cuff pressure up to 190 mmHg
  bp8_c_AdultMode_Adult    = $01; // Adult; cuff pressure up to 290 mmHg

type
  Tbp8_AdultMode = bp8_c_AdultMode_Children..bp8_c_AdultMode_Adult;

const
  // Bluetooth module operation modes
  bp8_c_BT_Mode_Auto    = $00;
  bp8_c_BT_Mode_Enabled = $01;
  bp8_c_BT_Mode_Disable = $02;

type
  Tbp8_BT_Mode = bp8_c_BT_Mode_Auto..bp8_c_BT_Mode_Disable;

type
  // System preferences
  Tbp8_DevOperationMode_System = packed record
    Time: TTimeS;   // Date and time of device initialization in 32-bit POSIX time form
  end;

  // Registration module settings
  Tbp8_DevOperationMode_RegistratorInf = packed record
    ADCCount       : u8; // Number of used ADC
                         //   

    RegChannelCount: u8; // Number of used channels
                         //    

    GroupCount     : u8; // Number of recording channels groups
                         //     
  end;

  // ADC options
  Pbp8_DevOperationMode_ADC = ^Tbp8_DevOperationMode_ADC;
  Tbp8_DevOperationMode_ADC = packed record
    SampleRate        : u32; // Sampling frequency (dHz)
                             //   ( )

    SnapshotsPerBuffer: u16; // Number of snapshots in the ADC buffer
                             //     

    SampleSize        : u8 ; // Sample size (bytes)
                             //   ( )

    RegChannelCount   : u8 ; // Number of recording channels used (in this ADC)
                             //     (  )
  end;

  //Registration channel settings
  Pbp8_DevOperationMode_RegChannelInfo = ^Tbp8_DevOperationMode_RegChannelInfo;
  Tbp8_DevOperationMode_RegChannelInfo = packed record
    Frequency     : u32; // Sampling frequency (dHz)
                         //   ( )

    MaxSampleValue: u16; // Dynamic range of the sample
                         //   

    ADCID         : u8 ; // Signal source (see ADCList, Sensor)
                         //  :  ADC (. ADCList, Sensor)

    SensorID      : u8 ; // Sensor ID  (see SensorList)
                         //  :   (. SensorList)

    SampleTime    : u8 ; // ADC sampling time for the channel
                         //      

    FilterType    : u8 ; // Type of digital signal processing (see bp8_c_FilterType_XXX constants)
                         //      (. bp8_c_FilterType_XXX )

    FilterParam   : u32; // Filter parameter. Appointment depends on the type of filter
                         //  .       (.  FilterType)

    GroupID       : u8 ; // Group number, which is assigned to this registration channel
                         //  ,      
  end;

  // Blood pressure monitor settings
  Tbp8_DevOperationMode_BPMonitorInf = packed record
    FuncMode                : u8 ;     // Operation mode of the blood pressure measurement modfule (see Tbp8_FuncMode)
                                       //      (. Tbp8_FuncMode)

    AdultMode               : u8 ;     // Age range (see Tbp8_AdultMode)
                                       //   (. Tbp8_AdultMode)

    MaxPress                : u16;     // Maximum allowable pressure in the cuff for the patient - 48 mmHg
                                       //         ( . .)

    EnableLongTimeStep      : u8 ;     // Not used
                                       //  

    EnableOrtoStart         : u8 ;     // Enable triggering conditions orthostatic test
                                       //      .

    EnableOneTimeMeasurement: u8 ;     // Not used. (Enable single measurement mode)
                                       //  . (     )

    EnableAuscultation      : u8 ;     // Enable the auscultatory method
                                       //   .

    EnableBeep              : u8 ;     // Enable audio signal before measuring
                                       //      .

    EnableShowResults       : u8 ;     // Enable results indicating at the end of the measurement
                                       //      .

    BPThreshold             : u8 ;     // Relative change (%) pressure or heart rate, beyond which repeated measurements.
                                       //   (%)   ,      .

    BPIntervalCount         : u8 ;     // Number of predetermined BP measurement intervals (see BPIntervalList)
                                       //   0 : pressure measurement will not performed
                                       //      (. BPIntervalList).
                                       //   0 :    .

    BTOffTimeout            : TTimeMS; // Bluetooth OFF timeout (ms) since the end of the session
                                       //   0 : Bluetooth is ON all the time.
                                       //  ( )  Bluetooth     .
                                       //   0 : Bluetooth  .

    VerifyBP                : u8 ;     // Start monitoring with verification measurements
                                       //   0 : The first measurement after initialization is considered to be planned
                                       //   1 : The first measurement after initialization is considered a verification
                                       //     :
                                       //   0 :      
                                       //   1 :      

    DataProtected           : u8 ;     // Prohibition data cleaning without connecting to a PC
                                       //          

    Reserved                : array[0..2] of u8;

    PMDEnable               : u8 ;     // Enable artificial pacemaker detector
                                       //    

    BT_Mode                 : u8;      // Bluetooth module operation mode (see Tbp8_BT_Mode)
                                       //   Bluetooth 

    MonitoringTimeMax       : TTimeMS; // Maximum length of monitoring period
                                       //     
  end;

  // Defines the time between measurements of blood pressure during the specified period of time of day
  Pbp8_DevOperationMode_BPInterval = ^Tbp8_DevOperationMode_BPInterval; //    TModeBPInterval
  Tbp8_DevOperationMode_BPInterval = packed record
    BeginTime          : TTimeS;  // Start time of the period in seconds from 00:00 of the current day
                                  //       00:00  

    EndTime            : TTimeS;  // End time of the period in seconds from 00:00 of the current day
                                  //       00:00  

    MeasurementInterval: TTimeS;  // Interval between measurements in seconds
                                  //   0 : measure in this range is not performed.
                                  //     .
                                  //   0:      .
  end;

  //Extended device operation mode (not available in standart SDK)
  Pbp8_SetupDataExt = ^Tbp8_SetupDataExt;
  Tbp8_SetupDataExt = packed record
    System        : Tbp8_DevOperationMode_System;         // System preferences
    RegistratorInf: Tbp8_DevOperationMode_RegistratorInf; // Registration module settings
    BPMonitorInf  : Tbp8_DevOperationMode_BPMonitorInf;   // Blood pressure monitor settings
    CRC           : u32;                                  // Device operation mode CRC
  end;

  //Device operation mode
  Pbp8_SetupData = ^Tbp8_SetupData;
  Tbp8_SetupData = packed record
    Time                     : TTimeS;  // Date and time of device initialization in 32-bit POSIX time form
                                        //        POSIX time

    EnableAdultMode          : u8;      // Age range (see Tbp8_AdultMode)
                                        //   (. Tbp8_AdultMode)

    EnableBeepFlag           : u8;      // Enable audio signal before measuring
                                        //      .

    EnableShowResultsFlag    : u8;      // Enable results indicating at the end of the measurement
                                        //      .

    EnableLongTimeStep       : u8;      // Not used
                                        //  

    EnableOrtoStartFlag      : u8;      // Enable triggering conditions orthostatic test
                                        //      .

    EnableOneTimeMeasurement : u8;      // Not used. (Enable single measurement mode)
                                        //  . (     )

    EnabledAuscultaticFlag   : u8;      // Enable the auscultatory method
                                        //   .

    FuncMode                 : u8;      // Operation mode of the blood pressure measurement modfule (see Tbp8_FuncMode)
                                        //      (. Tbp8_FuncMode)

    Threshold                : u8;      // Relative change (%) pressure or heart rate, beyond which repeated measurements.
                                        //   (%)   ,      .

    MaxPress                 : u16;     // Maximum allowable pressure in the cuff for the patient ? 48 mmHg
                                        //         ( . .)

    BT_OFF_TIMEOUT           : TTimeMS; // Bluetooth OFF timeout (ms) since the end of the session
                                        //   0 : Bluetooth is ON all the time.
                                        //  ( )  Bluetooth     .
                                        //   0 : Bluetooth  .

    EnableVerifyPressureStart: u8;      // Start monitoring with verification measurements
                                        //   0 : The first measurement after initialization is considered to be planned
                                        //   1 : The first measurement after initialization is considered a verification
                                        //     :
                                        //   0 :      
                                        //   1 :      

    DeviceModeDataProtected  : u8;      // Prohibition data cleaning without connecting to a PC
                                        //          

    PMDEnable                : u8;      // Enable artificial pacemaker detector
                                        //    

    BT_Mode                  : u8;      // Bluetooth module operation mode (see Tbp8_BT_Mode)
                                        //   Bluetooth 

    MonitoringTimeMax        : TTimeMS; // Maximum length of monitoring period
                                        //     

    CRC32                    : u32;     // Device operation mode CRC
  end;


// Measurement results
  // Time of measurement
  Tbp8_BPM_TimeInfo = packed record
    BaseTime : TTimeS;  // Date and time of device initialization in 32-bit POSIX time form
                        //        POSIX

    StartTime: TTimeMS; // Measurement start timestamp (ms) relative to BaseTime
                        //    ()  BaseTime

    EndTime  : TTimeMS; // Measurement complete timestamp (ms) relative to BaseTime
                        //    ()  BaseTime
  end;

  // Monitor status
  //  
  Tbp8_BPM_Status = packed record
    MeasType      : u16;     // Measurement type (see bp8_c_MeasType_XXX constants)
                             //   (.  bp8_c_MeasType_XXX)

    Reason        : u16;     // Cause measure  (see Field MeasType and bp8_c_MeasReason_XXX constants)
                             //    (.  MeasType   bp8_c_MeasReason_XXX)

    Err           : u16;     // Error code
                             //  

    BatteryVoltage: u16;     // Voltage at the beginning of the blood pressure measuring (samples)
                             //       ()
  end;

  // Result of blood pressure measurement
  //    
  Tbp8_BPM_PressureResult = packed record
    Sys : u16;     // Systolic blood pressure (mmHg)
                   //   ( . .)

    Mean: u16;     // Mean blood pressure ( mmH g)
                   //   ( . .)

    Dia : u16;     // Diastolic blood pressure (mmHg)
                   //   ( . .)

    Hrt : u16;     // Heart rate (beats/min)
                   //    (/)
  end;

  //   
  Tbp8_BPM_MapResult = packed record
    TimeRange: u16;  // Duration of time frame before the measurement is started, while the data acquisition and analysis was performed. The range is in 0 - 150 (unit corresponds to 2 s)
                     //   ,       .   0 - 150 (  2 ).

    Activity : u16;  // Activity value
                     //  

    X        : u8 ;  // X angle code
                     //   X

    Y        : u8 ;  // Y angle code
                     //   Y

    Z        : u8 ;  // Z angle code
                     //   Z

    Z1       : u8 ;  // Z1 angle code
                     //   Z1

    NChanges : u16;  // Amount of change in body position on the observation interval
                     //       
  end;

  // Measurement MAP data
  Tbp8_BPM_MapResults = packed record
    Before    : Tbp8_BPM_MapResult; // MAP data before the BP measurement
                                    //      

    After     : Tbp8_BPM_MapResult; // MAP data at the end of BP measurement
                                    //      
  end;

  //      - 
  // Result of blood pressure measured via the auscultatory method
  Tbp8_BPM_AuscResult = packed record
    Sys: u16;  // Systolic blood pressure measured via the auscultatory method ? 48 (mmHg)
               //  ,    - 48 ( . .)

    Dia: u16;  // Diastolic blood pressure measured via the auscultatory method (mmHg)
               //  ,    ( . .).
  end;

  // Result of blood pressure
  Pbp8_BPM_Result = ^Tbp8_BPM_Result;
  Tbp8_BPM_Result = packed record
    TimeInfo: Tbp8_BPM_TimeInfo;       // Time of measurement
    Status  : Tbp8_BPM_Status;         // Monitor status
    Pressure: Tbp8_BPM_PressureResult; // Result of blood pressure measurement
    Map     : Tbp8_BPM_MapResults;     // Measurement MAP data
    Ausc    : Tbp8_BPM_AuscResult;     // Result of blood pressure measured via the auscultatory method
  end;

  Tbp8_BPResult_MeasInfo = packed record
    MeasType      : u16;     // Measurement type (see bp8_c_MeasType_XXX constants)
                             //   (.  bp8_c_MeasType_XXX)

    BaseTime      : TTimeS;  // Date and time of device initialization in 32-bit POSIX time form
                             //        POSIX

    MeasTimeStart : TTimeMS; // Measurement start timestamp (ms) relative to BaseTime
                             //    ()  BaseTime

    MeasTimeEnd   : TTimeMS; // Measurement complete timestamp (ms) relative to BaseTime
                             //    ()  BaseTime

    BPSys         : u16;     // Systolic blood pressure - 48 (mmHg)
                             // .  (   48)

    BPMean        : u16;     // Mean blood pressure - 48 (mmHg)
                             //   (   48)

    BPDia         : u16;     // Diastolic blood pressure (mmHg)
                             // . ,   0  255 ...

    BPHrt         : u16;     // Heart rate (beats/min)
                             // CC,    0  255 /.

    BPErr         : u16;     //  Error code
                             //   

    Reserved      : u32;

    BatteryVoltage: u16;     // Voltage at the beginning of the blood pressure measuring (samples)
                             //     

    MeasReason    : u16;     // Cause measure  (see Field MeasType and bp8_c_MeasReason_XXX constants)
                             //   

    Reserved2     : u16;
  end;

  Tbp8_BPResult_MAP_Info = packed record
    MAP_OptionCase: u16;   //   .    ,   FFh
    MAP_SN        : u16;   //   
  end;

  Tbp8_BPResult_MAP_Before = packed record
    MAP_Before_Tsr1       : u16; // Duration of time frame before the measurement is started, while the data acquisition and analysis was performed. The range is in 0 - 150 (unit corresponds to 2 s)
                                 // .   T1,        0 - 510 . (  2 .) }

    MAP_Before_Activity   : u16; // Activity value
                                 //  , ,            X, Y, Z    T1,    

    MAP_Before_XY_Angles  : u16; // 0-3 bit - X angle code; 4-7 bit - Y angle code
                                 // 0-3 . -   X; 4-7 . -   Y (.  "     ")

    MAP_Before_ZZ1_Angles : u16; // 0-3 bit - Z angle code; 4-7 bit - Z1 angle code
                                 // 0-3 . -   Z; 4-7 . -   Z1 (.  "     ")

    MAP_Before_NChanges   : u16; // Amount of change in body position on the observation interval Tsr1.
                                 //        T1

    MAP_Before_Temperature: u16; // Not used
                                 //  
  end;

  Tbp8_BPResult_MAP_After = packed record
    MAP_After_Tsr2      : u16;   // Duration of time frame before the measurement is started, while the data acquisition and analysis was performed. The range is in 0 - 150 (unit corresponds to 2 s)
                                 // .   T2,         0  510 . (  2 .)

    MAP_After_Activity  : u16;   // Activity value
                                 //  , ,            X, Y, Z    T2,    


    MAP_After_XY_Angles : u16;   // 0-3 bit - X angle code; 4-7 bit - Y angle code
                                 // 0-3 . -   X; 4-7 . -   Y (.  "     ")

    MAP_After_ZZ1_Angles: u16;   // 0-3 bit - Z angle code; 4-7 bit - Z1 angle code
                                 // 0-3 . -   Z; 4-7 . -   Z1 (.  "     ")

    MAP_After_NChanges  : u16;   // Amount of change in body position on the observation interval Tsr2.
                                 //        T2
  end;

  Tbp8_BPResult_Ausc = packed record
    Ausc_BPSys: u16;  // Systolic blood pressure measured via the auscultatory method
                      //  ,   

    Ausc_BPDia: u16;  // Diastolic blood pressure measured via the auscultatory method (mmHg)
                      //  ,    ( . .).
  end;

  Pbp8_BPResultsTable = ^Tbp8_BPResultsTable;
  Tbp8_BPResultsTable = packed record
    MeasInfo  : Tbp8_BPResult_MeasInfo;
    MAP_Info  : Tbp8_BPResult_MAP_Info;
    MAP_Before: Tbp8_BPResult_MAP_Before;
    MAP_After : Tbp8_BPResult_MAP_After;
    Ausc      : Tbp8_BPResult_Ausc;
  end;

  Pbp8_Event = ^Tbp8_Event;
  Tbp8_Event = packed record
    TimeStamp: TTimeMS;         // Event timestamp in milliseconds since initialization of the device
                                //         

    case boolean of
      true: // It's true record
      (
        case EventType: u16 of      // Event type (see bp8_c_EventTypeID_XXX constants)
                                    //    (.  bp8_c_EventTypeID_XXX)

          // Further information on the event. Interpretation depends on the type of event
          //    .     .
          bp8_c_EventTypeID_Undefined       : (UserData     : u32);
          bp8_c_EventTypeID_GroupRecordStart: (GroupID      : u32);
          bp8_c_EventTypeID_Error           : (ErrorID      : u32);
          bp8_c_EventTypeID_PeripheralsON,
          bp8_c_EventTypeID_PeripheralsOFF  : (PeripheralsID: u32); //see Tbp8_PeripheralsID
          bp8_c_EventTypeID_Max             : (ChannelNum   : u32); //It's not correct, but need for compatibility with API BP2008SDK_XXXXXXXXXXXX //     ,      API BP2008SDK_XXXXXXXXXXXX
       );
      false: // need for compatibility with API BP2008SDK_XXXXXXXXXXXX
      (
        MarkType: u16;
      )
  end;

  Pbp8_Stage = ^Tbp8_Stage;
  Tbp8_Stage = packed record
    StepStart     : TTimeMS; // Stage begin timestamp (ms) relative to BaseTime
                             //    (ms)  BaseTime

    StepEnd       : TTimeMS; // Stage end timestamp (ms) relative to BaseTime
                             //    (ms)  BaseTime

    Pressure      : u16;     // Cuff pressure
                             //    ( . .)

    PulseAmplitude: s16;     // Pulse amplitude
                             //  
  end;

  Pbp8_ChannelSessionInfo = ^Tbp8_ChannelSessionInfo;
  Tbp8_ChannelSessionInfo = packed record
    StartTime   : TTimeMS; // Start time of session
                           //   

    SampleSize  : u8;      // Sample size (bytes)
                           //  

    SamplesCount: u32;     // Number of samples in session
                           //    
  end;

  // Finished result of command "Get current pressure in the cuff"
  Pbp8_CurrentPressure = ^Tbp8_CurrentPressure;
  Tbp8_CurrentPressure = packed record
    Proc_First: f32;   // The blood pressure from the main sensor
                       //    .

    Proc_Second: f32;  // The blood pressure from emergency sensor
                       //    () .
  end;

  // Result of command "Get data activity mo dule"
  Pbp8_MapSignals = ^Tbp8_MapSignals;
  Tbp8_MapSignals = packed record
    Kx  : s16;
    Ky  : s16;
    Kz  : s16;
    Kz1 : s16;
    K0x : s16;
    K0y : s16;
    K0z : s16;
    K0z1: s16;
  end;

  // Result of command "Get the device status"
  Pbp8_MonitorState = ^Tbp8_MonitorState;
  Tbp8_MonitorState = packed record
    ErrIdx: u32;     // The status code of latest measurement
    ErrorClass: u16; // Class of the error
    GuardState: u16; // Guard error code
  end;

  Pbp8_PressureCalibrationInfo = ^Tbp8_PressureCalibrationInfo;
  Tbp8_PressureCalibrationInfo = packed record
    MainMaxMin  : Tbp8_ChannelMaxMin;
    GuardMaxMin : Tbp8_ChannelMaxMin;
    GuardCorr   : s16;
  end;

//Validation monitor data
const
  bp8_c_MonitorDataSourceType_Configuration     = byte($00); // Configuration
  bp8_c_MonitorDataSourceType_OperationMode     = byte($01); // Operation mode
  bp8_c_MonitorDataSourceType_Metadata          = byte($02); // Metadata
  bp8_c_MonitorDataSourceType_BPMResults        = byte($03); // Blood pressure measure results
  bp8_c_MonitorDataSourceType_Events            = byte($04); // Events
  bp8_c_MonitorDataSourceType_PressureStage     = byte($05); // Pressure stages
  bp8_c_MonitorDataSourceType_Signals           = byte($06); // Signals

type
  Tbp8_MonitorDataSourceType = bp8_c_MonitorDataSourceType_Configuration..bp8_c_MonitorDataSourceType_Signals;

  Tbp8_MonitorDataSource = packed record
    DataType    : u8; //see bp8_c_MonitorDataSource_XXX constants

    {next fields for siglals}
    GroupNumber  : u8;
    SessionNumber: u16;
  end;


  Pbp8_DataValidInfo = ^Tbp8_DataValidInfo;
  Tbp8_DataValidInfo = packed record
    DataSource: Tbp8_MonitorDataSource;
    State: u32;
  end;


//*********************************************************
//   API BP2008SDK_XXXXXXXXXXXX
//*********************************************************
const
  BP2008SDK_AUGMENT_ERROR       = bp8_c_Augment_Error     ;
  BP2008SDK_AUGMENT_DISABLED    = bp8_c_Augment_Disabled  ;
  BP2008SDK_AUGMENT_IN_PROGRESS = bp8_c_Augment_InProgress;
  BP2008SDK_AUGMENT_HOLD        = bp8_c_Augment_Hold      ;

  BP2008SDK_UndefInterface = bp8_mi_None     ;
  BP2008SDK_DirInterface   = bp8_mi_Directory;
  BP2008SDK_USBInterface   = bp8_mi_FTDI     ;
  BP2008SDK_BTInterface    = bp8_mi_BT       ;
  BP2008SDK_COMInterface   = bp8_mi_COM      ;
  BP2008SDK_HIDInterface   = bp8_mi_HID      ;

type
  PBP2008_InitParams = ^TBP2008_InitParams;
  TBP2008_InitParams = record
    AutoInitBTLib: WordBool;
  end;

  TModuleHandle = HINST;

  {TO DO  .    API}
  PSetupData_SDK = Pbp8_SetupData;
  TSetupData_SDK = Tbp8_SetupData;

  //   Tbp8_DevOperationMode_BPInterval
  TModeBPInterval = packed record
    IntervalBegin  : TTimeS; //       00:00
    IntervalEnd    : TTimeS; //       00:00
    IntervalBetween: TTimeS; //     .  0 -      
  end;
  PMeasInterval = ^TModeBPInterval;

  PSignature_SDK = Pbp8_Signature;
  TSignature_SDK = Tbp8_Signature;


  TBPResult_MeasInfo   = Tbp8_BPResult_MeasInfo;
  TBPResult_MAP_Info   = Tbp8_BPResult_MAP_Info;
  TBPResult_MAP_Before = Tbp8_BPResult_MAP_Before;
  TBPResult_MAP_After  = Tbp8_BPResult_MAP_After;
  TBPResult_Ausc       = Tbp8_BPResult_Ausc;

  PBPResultsTable_SDK = Pbp8_BPResultsTable;
  TBPResultsTable_SDK = Tbp8_BPResultsTable;

const
  Signal_Unknown     = bp8_c_SigChannel_Unknown;
  Signal_Power       = bp8_c_SigChannel_Power;
  Signal_Press       = bp8_c_SigChannel_Press;
  Signal_Auscultic   = bp8_c_SigChannel_Auscultic;
  Signal_Cardio_I    = bp8_c_SigChannel_Cardio_I;
  Signal_Cardio_II   = bp8_c_SigChannel_Cardio_II;
  Signal_Cardio_III  = bp8_c_SigChannel_Cardio_III;
  Signal_Cardio_LR   = bp8_c_SigChannel_Cardio_LR;
  Signal_Cardio_RF   = bp8_c_SigChannel_Cardio_RF;
  Signal_Cardio_V1   = bp8_c_SigChannel_Cardio_V1;
  Signal_Cardio_V2   = bp8_c_SigChannel_Cardio_V2;
  Signal_Cardio_V3   = bp8_c_SigChannel_Cardio_V3;
  Signal_Cardio_V4   = bp8_c_SigChannel_Cardio_V4;
  Signal_Cardio_V5   = bp8_c_SigChannel_Cardio_V5;
  Signal_Cardio_V6   = bp8_c_SigChannel_Cardio_V6;
  Signal_MAPx        = bp8_c_SigChannel_MAPx;
  Signal_MAPy        = bp8_c_SigChannel_MAPy;
  Signal_Microphone  = bp8_c_SigChannel_Microphone;

  //for compatibility with old designations (CR#0008877)
  Signal_Cardio_LP   = bp8_c_SigChannel_Cardio_LP;
  Signal_Cardio_LN   = bp8_c_SigChannel_Cardio_LN;

type
  TSignalType = Tbp8_SigChannelType;
  TSignalTypeSet = Tbp8_SigChannelSet;
const
  BP2008SDK_ECGSignalTypes: TSignalTypeSet =
    [Signal_Cardio_I   //  I 
    ,Signal_Cardio_II  //  II 
    ,Signal_Cardio_III //  III 
    ,Signal_Cardio_LR  //  LR
    ,Signal_Cardio_RF  //  RF
    ,Signal_Cardio_V1  //  V1
    ,Signal_Cardio_V2  //  V2
    ,Signal_Cardio_V3  //  V3
    ,Signal_Cardio_V4  //  V4
    ,Signal_Cardio_V5  //  V5
    ,Signal_Cardio_V6  //  V6
    ];

  BP2008SDK_PressureSignalTypes: TSignalTypeSet =
    [Signal_Press,      // 
     Signal_Auscultic   //  
    ];

  BP2008SDK_MAPSignalTypes: TSignalTypeSet =
    [Signal_MAPx,       //  x
     Signal_MAPy        //  y
    ];

  BP2008SDK_MicrophoneSignalTypes: TSignalTypeSet =
    [Signal_Microphone  // 
    ];

type
  PLogicalChannelInfo = Pbp8_SigChannelInfo;
  TLogicalChannelInfo = Tbp8_SigChannelInfo;

  PLogicalChannelMaxMin = Pbp8_ChannelMaxMin;
  TLogicalChannelMaxMin = Tbp8_ChannelMaxMin;

  PPressureCalibrationInfo = Pbp8_PressureCalibrationInfo;
  TPressureCalibrationInfo = Tbp8_PressureCalibrationInfo;

  PChannelSession = ^TChannelSession;
  TChannelSession = packed record
    StartTime: TTimeMS; //   
    SamplesCount: u32;  //    
  end;

  TSignalSample = u16;
  PSignal = ^TSignalSample;
  TSignalSamples = array of TSignalSample;

const
  pridPump = bp8_c_PeripheralsID_Pump;

type
  TPeripheralsID = Tbp8_PeripheralsID;
  PMeasMark = Pbp8_Event;
  TMeasMark = Tbp8_Event;
  TMeasMarks = array of TMeasMark;
  TMeasMark_Type = Tbp8_EventTypeID;

const
  mmtUndefined                = bp8_c_EventTypeID_Undefined       ;
  mmtPulse                    = bp8_c_EventTypeID_Pulse           ;
  mmtUserEvent                = bp8_c_EventTypeID_UserEvent       ;
  mmtChannelRegistrationBegin = bp8_c_EventTypeID_GroupRecordStart;
  mmtPMDUpSet                 = bp8_c_EventTypeID_PMD             ;
  mmtPMDUpReset               = $0005                             ; // 
  mmtPMDDownSet               = $0006                             ; // 
  mmtPMDDownReset             = $0007                             ; // 
  mmtPeripheralsON            = bp8_c_EventTypeID_PeripheralsON   ;
  mmtPeripheralsOFF           = bp8_c_EventTypeID_PeripheralsOFF  ;
  mmtERROR                    = bp8_c_EventTypeID_Error           ;
  mmtMonitorStart             = bp8_c_EventTypeID_MonitorStart    ;
  mmtMAX                      = bp8_c_EventTypeID_Max             ;

type
  PMAPCalibration = Pbp8_DevConfig_MAPCalibration;
  TMAPCalibration = Tbp8_DevConfig_MAPCalibration;

  PMeasStep = Pbp8_Stage;
  TMeasStep = Tbp8_Stage;
  TMeasSteps = array of TMeasStep;

  PCurrentPressure = Pbp8_CurrentPressure;
  TCurrentPressure = Tbp8_CurrentPressure;

  PMapSignals = Pbp8_MapSignals;
  TMapSignals = Tbp8_MapSignals;

  PMonitorState = Pbp8_MonitorState;
  TMonitorState = Tbp8_MonitorState;

  TFuncMode = Tbp8_FuncMode;

const
  FuncMode_TECHNOLOGICAL = bp8_c_FuncMode_Technology;
  FuncMode_CERTIFICATION = bp8_c_FuncMode_Certification;
  FuncMode_CLINICAL      = bp8_c_FuncMode_Clinical;

  c_SERIAL_NUMBER_SIZE = bp8_c_SerialNumberLength;
  c_VERSION_SIZE       = bp8_c_VersionFWLength;


const
  BP2008SDK_FirstMonitorHandle: TMonitorHandle = 0;

const
{State codes of emergency lock}
  BP2008SDK_lockTime120         = bp8_c_sclTime120;
  BP2008SDK_lockPres295         = bp8_c_sclPres295;
  BP2008SDK_lockPres320         = bp8_c_sclPres320;
  BP2008SDK_pres15              = bp8_c_sclPres15;
  BP2008SDK_lockNo30sec         = bp8_c_sclNo30sec;
  BP2008SDK_lockMainMaxOffset   = bp8_c_sclMainMaxOffset;
  BP2008SDK_lockMainMinOffset   = bp8_c_sclMainMinOffset;
  BP2008SDK_lockGuardMaxOffset  = bp8_c_sclGuardMaxOffset;
  BP2008SDK_lockGuardMinOffset  = bp8_c_sclGuardMinOffset;

//*********************************************************

